const { src, dest, parallel,watch } = require('gulp');
const browserSync = require('browser-sync').create();
const pug = require('gulp-pug');
const less = require('gulp-less');
const minifyCSS = require('gulp-csso');
const concat = require('gulp-concat');
const autoprefixer = require ( 'gulp-autoprefixer' );
const replace = require('gulp-string-replace');
function browser() {
  htmlKF()
  css()
  jsKF()
  watch('src/style/*.less', parallel(css,reload))
  watch('src/js/*.js', parallel(jsKF,reload))
  watch('src/**/*.pug',parallel(htmlKF,reload))
  browserSync.init({ server: { 
    baseDir: "./build/" ,
    host: '0.0.0.0'
  } });
}

function htmlKF() {
  return src('src/*.pug')
    .pipe(replace('//- 这里的提示是为了给脚本定位打包的时候自动插入客服的不要删','script(src="https://tb.53kf.com/code/code/10191018/3")'))
    .pipe(pug())
    .pipe(dest('build/'))
}

function htmlNoKF() {
  return src('src/*.pug')
    .pipe(replace('//- 这里的提示是为了给脚本定位打包的时候自动插入客服的不要删',''))
    .pipe(pug())
    .pipe(dest('build/'))
}

function css() {
  return src('src/style/*.less')
    .pipe(less())
    .pipe(autoprefixer({
      cascade : true ,
      remove : true
    }))
    .pipe(minifyCSS())
    .pipe(dest('build/css'))
}

function jsKF() {
  const buffer = `window.open('https://www26.53kf.com/webCompany.php?kf_sign=TYxOTMTU1OQ2MTEwNjQzMzU0Nzg4MDA3NzIxOTEwMTg=&arg=10191018&style=3&language=zh-cn&charset=GBK&kflist=off&kf=&zdkf_type=1&lnk_overflow=0&callback_id6ds=&referer=http%3A%2F%2Flocalhost%3A3000%2F&keyword=http%3A%2F%2Flocalhost%3A3000%2F&tfrom=1&tpl=crystal_blue&uid=b6385c8ea617caf08224345b545969e1&is_group=&is_group=&timeStamp=1559619541851&ucust_id=', '_blank', 'height=600,width=800,top=50,left=200,status=yes,toolbar=no,menubar=no,resizable=yes,scrollbars=no,location=no,titlebar=no')`;
  return src('src/js/*.js', { sourcemaps: true })
    .pipe(replace('// 这段注释是 js的客服提示部分，不要删除', buffer))
    .pipe(concat('app.min.js'))
    .pipe(dest('build/js', { sourcemaps: true }))
}

function jsNoKF() {
  const buffer = ``;
  return src('src/js/*.js', { sourcemaps: true })
    .pipe(replace('// 这段注释是 js的客服提示部分，不要删除', buffer))
    .pipe(concat('app.min.js'))
    .pipe(dest('build/js', { sourcemaps: true }))
}

function build(cb) {
  htmlKF()
  css()
  jsKF()
  cb()
}
function noKFBuild(cb) {
  htmlNoKF()
  css()
  jsNoKF()
  cb()
}
function reload(cb) {
  browserSync.reload()
  cb()
}

exports.default = browser
exports.kfBuild = build
exports.noKFBuild = noKFBuild