const { src, dest, parallel,watch } = require('gulp');
const browserSync = require('browser-sync').create();
const pug = require('gulp-pug');
const less = require('gulp-less');
const minifyCSS = require('gulp-csso');
const concat = require('gulp-concat');
const autoprefixer = require ( 'gulp-autoprefixer' );
const replace = require('gulp-string-replace');
function browser() {
  css()
  watch('src/style/**/*.less', parallel(css,reload))
  watch('src/js/**/*.js', parallel(js,reload))
  watch('src/**/*.pug',parallel(html,reload))
  browserSync.init({server: { baseDir: "./build/" , host: '0.0.0.0' }});
}

function html() {
  return src('src/*.pug').pipe(pug()).pipe(dest('build/'))
}

function css() {
  return src('src/style/*.less')
    .pipe(less())
    .pipe(autoprefixer({ cascade : true ,remove : true }))
    .pipe(minifyCSS())
    .pipe(dest('build/css'))
}

function js() {
  const buffer = ``;
  return src('src/js/*.js', { sourcemaps: true })
    .pipe(replace('// 这段注释是 js的客服提示部分，不要删除', buffer))
    .pipe(concat('app.min.js'))
    .pipe(dest('build/js', { sourcemaps: true }))
}

function build(cb) {
  html();
  css();
  js();
  cb();
}

function reload(cb) {
  browserSync.reload()
  cb()
}

exports.default = browser
exports.build = build